/*  (c) 1991 S.Hawtin
   Permission is granted to make any use of this file provided
    1) It is not used for commercial gain without my permission
    2) This notice is included in all copies
    3) Altered copies are marked as such

  No liability is accepted for the contents of the file.

*/

/* Set up the structures for use in juggling */

#define NAME_LEN  128
#define MAX_BALLS 10
#define MAX_HANDS 2
#define MAX_MOVES 100
#define DEF_GRAVITY   2
#define SCALE_FACTOR 100

#define NAME        "jug"
#define MAJ_VERSION 1
#define MIN_VERSION 0

/* Any ball with this y position is not in action */
#define DEFAULT   -999
#define INFINITY  9999

#define arraysize(array) (sizeof(array)/sizeof(array[0]))

typedef struct
   {char alias[NAME_LEN];	/* Either called ball1 or this name */
    int  x,y,z,dx,dy,dz;	/* Position and acceleration of balls */
    int  o_x,o_y,o_z;
    int  ball_num;
    } Ball;

typedef struct
   {char alias[NAME_LEN];	/* Either called hand1 or this name */
    int  def_x,def_y,def_z;	/* "At rest" position of hand */
    int  backwards;		/* -1 True if +ve throws go in -ve direction otherwise +1 */
    char pict[4];		/* How to draw the hand "***\0" needs null */
    int  x,y,z;			/* Position of hands */
    int  r_x,r_y,r_z;
    int  o_x,o_y,o_z;
    int  num_balls;		/* Balls being held by this hand */
    Ball *balls[MAX_BALLS];
    int  hand_num;
    } Hand;

/* The things to do */
#define MOVE_NOP	0

/* Offsets for parameters */
#define OFF_HAND	0
#define OFF_BALL	1
#define OFF_X		2
#define OFF_Y		3
#define OFF_Z		4
#define OFF_DX		5
#define OFF_DY		6
#define OFF_DZ		7
#define OFF_LABEL	8
#define OFF_LAST	9

/* Flags for parameter descriptions */
#define PARAM_VALID	1
#define PARAM_DEFAULT	2
#define PARAM_IMMEDIATE 4
#define PARAM_SET	8

typedef struct
   {
    char name[20];
    void (*fun)();
    int  param[OFF_LAST];	/* hand,ball,x,y,z,dx,dy,dz,label */
    } MoveAction;

typedef struct
   {int time,what;		/* When to do it, and what to do */
    int  param[OFF_LAST];	/* hand,ball,x,y,z,dx,dy,dz,label */
    MoveAction *cmnd;
    } MoveInst;
