/*  (c) 1991 S.Hawtin
   Permission is granted to make any use of this file provided
    1) It is not used for commercial gain without my permission
    2) This notice is included in all copies
    3) Altered copies are marked as such

  No liability is accepted for the contents of the file.

*/

/* Display the current position with a simple ASCII based display, this 
is written to be as portable as possible */

/**********************************************************************/

/* This portion creates an array of chars for the screen and outputs it */

#include <stdio.h>

#include "jug.h"

#define arraysize(array) (sizeof(array)/sizeof(array[0]))

#define SCREEN_WIDTH  60
#define SCREEN_HEIGHT 21
#define X_SCALE 0.04
#define Y_SCALE 0.01
#define X_OFFSET 10
#define Y_OFFSET 16
#define BALL_RADIUS 1
#define RETURN_X 20
#define RETURN_Y 20

int time_x = 0;
int time_y = RETURN_X;
int ball_offset = 2*BALL_RADIUS/X_SCALE;

double x_scale = X_SCALE;
double y_scale = Y_SCALE;

typedef struct
   {int len;
    char str[SCREEN_WIDTH];
    } Line;

Line screen[SCREEN_HEIGHT];

screen_clr()
   {/* Clear all the screen */
    int count,c2;

    for(count=0;count<SCREEN_HEIGHT;++count)
       {screen[count].len = 0;
        for(c2=0;c2<SCREEN_WIDTH;++c2)
            screen[count].str[c2] = ' ';
        }
    }

out_string(x,y,str)
    int x,y;
    char *str;
   {/* Put out the string at x,y */
    int len,count;

    if(y<0 || y>=SCREEN_HEIGHT)
        return;

    len = strlen(str);
    if(x+len > SCREEN_WIDTH)
        len = SCREEN_WIDTH - x;
    for(count=((x<0)?-x:0);count<len;++count)
        screen[y].str[x+count] = str[count];
    if(screen[y].len < x+len)
        screen[y].len = x+len;
    }

screen_flush()
   {/* Put the current screen on to the terminal */
    int y;
    char temp;

    /* If you can find the sequence of characters that clear the screen 
      and put the cursor at the top left on your terminal adding it here 
      will improve the display */
#ifdef AMIGA
    /* Clear screen escape sequence */
    fputs("\033c",stdout);
#endif
#ifdef VT100
    /* Clear screen escape sequence */
    fputs("\033[2J\033[H",stdout);
#endif

    /* Put out the current screen */
    for(y=0;y<SCREEN_HEIGHT;++y)
       {temp = screen[y].str[screen[y].len];
        screen[y].str[screen[y].len] = '\0';
        puts(screen[y].str);
        screen[y].str[screen[y].len] = temp;
        }
    /* Now flush the buffer */
    fflush(stdout);
    }

init_screen(argc,argv)
    int *argc;
    char **argv;
   {/* Open the connection to the screen */
    }

tidy_screen()
   {/* Tidy up the screen connection */
    }

rescale()
   {/* The obvious bits of ASCII rescale are handled by jug.c */
    }

/***********************************************************************/

/* This portion converts the current position into an image on the 
   screen */

void
real_to_screen(x,y,z,screen_x,screen_y)
    int x,y,z;
    int *screen_x;
    int *screen_y;
   {/* Convert from real space to screen space assumes 2D screen !! */
    *screen_x = X_OFFSET + (int)(x_scale*x);
    *screen_y = Y_OFFSET - (int)(y_scale*y);
    }

draw_ball(x,y,z,ball)
    int x,y,z;
    Ball *ball;
   {char str[2];
    int s_x,s_y;

    real_to_screen(x,y,z,&s_x,&s_y);
    str[0] = ball->alias[0];
    str[1] = '\0';
    out_string(s_x,s_y,str);
    }

draw_hand(x,y,z,hand)
    int x,y,z;
    Hand *hand;
   {
    int s_x,s_y;

    real_to_screen(x,y,z,&s_x,&s_y);
    out_string(s_x-1,s_y+1,hand->pict);
    }

wait_step()
   {/* Wait for the user to do something before going on */
    char next;

    out_string(RETURN_X,RETURN_Y,"press <Return> or <?>");

    /* Now display the screen we have constructed */
    screen_flush();

    /* Wait for a character */
    do {
        next = getchar();
        process_key(next);
        } while (next!='\n' && next!='\r');
    }

int
is_option(num,argv,argc)
    int *num;
    char **argv;
    int argc;
   {/* Process some option for the grapics */

    /* Not a valid graphics option */
    return(0);
    }


