.\"
.TH JUG 6 "5 December 1991"
.SH NAME
jug \- animate juggling patterns
.SH SYNOPSIS
.B [a|x]jug 
[
.B \-? \-q \-s \-v
] [
.B \-t<maxTime>
] [
.B \-d<delayTime>
] [
.B \-g<gravity>
] [
.B \-p<clockDivisions>
] [
.B \-x<scale>
] [
.B \-e<verticalScale>
] [
.B \-b[<loopCount>]
] [
.I pattern
]
.SH DESCRIPTION
.IX "jug game" "" "\fLjug\fP game"
.LP
.B jug
reads a juggling pattern specified in a special language and animates 
the pattern on the output device.  Currently there are three versions of 
the program
.I jug
outputs to ASCII terminals
.I xjug
displays its output on an X window and
.I ajug
works on the Commodore Amiga 500.
.SH OPTIONS
.TP
.B \-? \-q
Display the usage of the program.
.TP
.B \-v
Display the version number of the program.
.TP
.B \-s
Normally the program will run in 
.B step
mode, that is the program will pause after each time step 
waiting for the user to hit a key or press a mouse button.  
The program can be placed into
.B run
mode by specifying this flag, this mode can also be inverted by the 
\'S\' single key command.
.TP
.BI \-t "maxTime"
The animation will keep going for a number of clock ticks 
this can be set with the
.B max-time
global variable or the \-t switch.  The value will be ignored 
if the 
.B loop-count
varibale is set.  The default value is 100.
.TP
.BI \-d "delayTime"
When the animation is running in 
.B run
mode it pauses for
.I delayTime
seconds between each clock tick.  This is normally set to 0.0 to 
make the animation continuous.
.TP
.BI \-g "gravity"
This sets the 
.B gravity
varibale, this determines the force of gravity in use for the animation.  If 
the 
.B gravity
varibale is set in the pattern file this will override the value on the 
command line.  The default value is 200.
.TP
.BI \-p "clockDivisions"
The animation draws 
.I clockDivision
images for each step, this makes the animation smoother at the expence 
of more calculation.  The default value depends on the graphics system.
.TP
.BI \-x "scale"
This sets the relative scale of the drawing.
.TP
.BI \-e "verticalScale"
This allows the user to extend the vertical exageration, if for example 
you wish to create a set of ASCII images for inclusion in text describing 
a pattern then you do not need the full height using this varible you can 
draw the patterns in half the lines.
.TP
.BI \-b "loopCount"
This sets the 
.B loop-count
varibale, this determines how many
.B goto
commands are obeyed, for example by setting the value to one the 
animation will only go through the pattern once.  If this is set it overrides the 
.B max-time
variable.
.TP
.I pattern
This determines the pattern to be shown, if the
.I pattern
is 
.B \-
then it is read from the standard input.  If a pattern name is 
given the program will attempt to open a file with that name as the 
pattern file, if this fails it will append ".jug" to the name and use that 
as the pattern name.
.SH USAGE
.LP
The program takes a descrition of juggles and draws them on the screen.  While 
the animation is running there are a number of single key commands that the 
program will respond to
.TP
.BI <Q>
Quit the program.
.TP
.B <Space> <Return>
Move to next step if in 
.B step
mode.
.TP
.BI <?>
Show a list of single key commands.
.TP
.BI <S>
Invert the
.B step
mode. If in single step mode start running continuously.
.TP
.BI <I>
Zoom in closer to the pattern.
.TP
.BI <O>
Zoom out further away.
.SH LANGUAGE
.LP
The juggles are specified using an English like language.  Comments are 
indicated by a '#', the rest of the line is treated as a comment.  The 
pattern discription is split into four elements, first the global variables are 
set, then the initial position is described, next the throws to get into 
the pattern are described, and finally the pattern itself is described.
.LP
The global variables are indicated using the '!' character.  There are a number 
of variables that can be set
.TP
.BI name
A string giving the name of the pattern.
.TP
.BI max-moves
The number of moves before quiting the program, this is overridden by the 
.B loop-count
variable.
.TP
.BI loop-count
The number of times to execute the 
.B loop
or
.B goto
command before quiting the program.  If this variable is set it will
override the 
.B max-moves
variable.
.TP
.BI gravity
The value of gravity, by default this is set to 200 but is altered to 
deal with objects such as scarfs.
.LP
The initial state of the hands is given by specfying the hand, the objects 
and the position, for example
.IP 
right blue black orange
.LP
places the blue, black and orange objects in the right hand
.IP 
left red green at 2
.LP
places the red and green objects in the left hand at position 2.  The 
hand positions are relative to 0, hand at rest position, and have 4 as 
the rest position of the other hand, so a position of 2 is half way 
between the hands.
.LP
The next component give the moves to get into the pattern, moves 
are specified with a time, so for example
.IP 
0: throw left red towards -2,5
.LP
tells the animation at time 0 to 
.I throw 
from the
.I left 
hand, with the 
.I red 
object 
.I towards 
the position -2,5 the speed is specified by the position the 
object will cross the same height going down, and time you wish 
this to occur.  So in this case we know that the 
.I red 
object will be at 0,0 at time 5, since it is being thrown from
2,0 at time 0 with speed -2,5.  So we know that we must add 
a command
.IP 
5: catch left
.LP
if we want to catch it at time 5 with the 
.I left
hand in the rest position.
.LP
The final component is to specify the pattern using the same format of 
commands as we have already seen.
.LP
The valid components in the pattern description language are
.TP 
.B throw
Throw an object at the specified time.
.TP 
.B catch
Catch the nearest object to the specified hand.
.TP 
.B move
Move a hand without doing anything else.
.TP 
.B swap
Use a different mapping of hands, useful just before a loop 
to do the same thing with the other hand.  Can also be used 
with balls to do the same thing with different balls.
.TP 
.B loop goto
Repeat the pattern from a previous point.
.TP 
.B hand
Modifier that specifies a hand to use via a number rather than a 
symbolic name.  Most useful with the swap command.
.TP 
.B ball
Modifier that specifies a ball to use via a number rather than a 
symbolic name.  Most useful with the swap command.
.TP 
.B position at from
Modifier that specifies a location as a triple of numbers giving the 
x,y,z position.
.TP 
.B speed towards
Modifier that specifies the speed of a throw.
.TP 
.B time label
Modifier that specifies the label for a jump.
.TP 
.B red green blue yellow violet cyan white black brown orange
An object, these are specified by colour.
.TP 
.B left right
A hand, at the moment only two are specified.
.SH BUGS
.LP
There are no bugs only features :-)
 
